/*
 * debug.c - print messages from various file streams safely
 * $Id: debug.c,v 1.6 2002/10/31 02:45:06 mathomas Exp $
 */
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <errno.h>
#include "debug.h"

/*
 * print error and terminate program 
 */

void
die(const char *msg)
{
        perror(msg);
        exit(errno);
}

/* 
 * stdout printing wrapper 
 */

void 
dump(const char *fmt, ...)
{
        va_list args;

        if(!fmt)
                return;

        va_start(args, fmt);
        (void) vfprintf(stdout, fmt, args);
        va_end(args);

        (void) fflush(stdout);
}

/* 
 * stderr printing wrapper 
 */

void 
error(const char *fmt, ...)
{
        va_list args; 
        
        if(!fmt)
                return; 
                
        va_start(args, fmt);
        (void) fprintf(stderr, "error: ");
        (void) vfprintf(stderr, fmt, args);
        va_end(args);

        (void) fflush(stderr);
}

/*
 * stderr printing wrapper and clean exit 
 */

void 
fatal(const char *fmt, ...)
{
        va_list args;

        if(!fmt)
                exit(EXIT_FAILURE);

        va_start(args, fmt);
        (void) fprintf(stderr, "fatal: ");
        (void) vfprintf(stderr, fmt, args);
        va_end(args);

        (void) fflush(stderr);
        (void) fflush(stdout);

        exit(EXIT_FAILURE);
}

