#include <locale.h>
#include <stdio.h>
#include "node.h"
#include "nameAnalyser.h"
#include "stdlib.h"

NODE* expTree;

int
main(int argc, char **argv) {

        extern int yyparse();
        NODE * root;
        EnvNode * rootEnv;
        SymbolTable * symTab;
        int i, result, interpError = 0, numParams = 0;

        setlocale(LC_ALL, ""); /* clean the environment */

        rootEnv = (EnvNode*) malloc(sizeof(EnvNode));
        initEnvNode(rootEnv);
        symTab = (SymbolTable*) malloc(sizeof(SymbolTable));
        initSymTab(symTab);

        interpError = yyparse();	/* do the parsing */
        
        if(!interpError) {		/* if no error found then analyse the tree */
            	interpError = analyseTree(expTree, rootEnv, symTab);
            	deleteEnvNode(rootEnv);
            
        	if(!interpError) {
            		for(i = 0; i < symTab->numEntries; i++) {
                		if(symTab->entries[i].isParam == 1) {
                    			numParams++;

                    		if(numParams <= argc-1)
                        		symTab->entries[i].value = atoi(argv[numParams]);
                		}
            		}

            	if(numParams == argc-1) {
                	result = evalTree(expTree, symTab);
                	printf("The program evaluated to: %i\n", result);
            	}
            else
                printf("Error: Unable to run program. Expected %i parameters, found %i parameters\n", numParams, argc-1);
        	}
        }
        
    	deleteSymTab(symTab);
    	return(0);
}
