/*
 *      Node by Mark Thomas and Owen Macindoe
 *      A data structure for holding expression tree information
 *     for an interpreter working on a subset of C.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <varargs.h>
#include "xalloc.h"
#include "node.h"

/* Create a new node */

static NODE *NewNode(int sNodeType)
{
    	register NODE *r = 0;

    	r = XMALLOC(NODE, 1);
    	memset(r, '\0', sizeof(NODE));
    	r->sNodeType = sNodeType;

    	return r;
}

/* add a node to the tree */

NODE *AddNode(NODE *left, int sNodeType, NODE *right)
{
   	register NODE *r;

   	r = NewNode(sNodeType);
   	r->NodeLeft  = left;
   	r->NodeRight = right;

   	return r;
}

/* append a node to the tree */

NODE *AppendNode(NODE *nodeList, NODE *nodeNew)
{
   	register NODE *oldlist;
   	oldlist = nodeList;

   	while (nodeList->NodeNext != NULL)
      		nodeList = nodeList->NodeNext;

   	nodeList->NodeNext = nodeNew;

   	return oldlist;
}

/* add a node with value equal to sValue */

NODE *AddNumber(int sValue)
{
  	register NODE *pNode;

   	pNode = NewNode(NODE_NUMBER);
   	pNode->vari.sValue = sValue;
   	pNode->sVariableType = TYPE_INTEGER;

   	return pNode;
}

/* add a node with value equal to pszName */

NODE *AddVariable(char *pszName)
{
   	register NODE *r;/* = FindVariable(pszName);*/
   	r = NewNode(NODE_VARIABLE);

   	strncpy(r->vari.szName, pszName, MAX_VAR_NAME_SIZE);
   	/* all variables default to integer type*/
   	r->sVariableType = TYPE_INTEGER;

   	return r;
}

/* delete a nodee from the three */

void DeleteNode(NODE * node) {
	if(node->NodeLeft != NULL)
		DeleteNode(node->NodeLeft);

	if(node->NodeRight != NULL)
		DeleteNode(node->NodeRight);

	if(node->NodeNext != NULL)
		DeleteNode(node->NodeNext);
	
	XFREE(node);
}

