#include "stdlib.h"
#include "stdio.h"
#include "string.h"


#include "schatter.h"
#include "schatter_x.h"
#include "client.h"
#include "configure.h"
#include "messages.h"
#include "util.h"


void client_execName(int slot, char* name) {

    int i;
    int intTest = -1;
    char msg[MSG_LENGTH];
    char oldname[STR_LENGTH];
    
    if (strcmp(name, clients[slot].strName) == 0) {
        /* The user already has this name and hence nothing needs to be done. */
        sendMessage(slot, MSG_CMD_NAME_SAME, sizeof(MSG_CMD_NAME_SAME));
        return;
    }

    /* Now test to make sure nobody else already is using this name. */
    intTest = -1;
    for (i=0; i < MAX_CLIENTS && intTest == -1; ++i) {
	    if (FD_ISSET(clients[i].intFD, &socks)) {
            if (strcmp(name, clients[i].strName) == 0) {
                /* We found a match. */
                intTest = i;
            }
        }
    }

    if (intTest != -1) {
        /* Since we found a match then some other client is already using this
         * name. */
        sendMessage(slot, MSG_CMD_NAME_TAKEN, sizeof(MSG_CMD_NAME_TAKEN));
        return;
    }

    /* Now that we have determined that this is a valid name to change to we can
     * go ahead and change to it. While were at it we will notify the user who
     * changed their name and also send a message to all other clients letting
     * them know as well. */
    memset(oldname, '\0', sizeof(oldname));
    Strncpy(oldname, clients[slot].strName, STR_LENGTH);
    Strncpy(clients[slot].strName, name, STR_LENGTH);
    
    memset(msg, '\0', sizeof(msg));
    sprintf(msg, "*** Your name has been changed to '%s'.\n",
        clients[slot].strName);
    sendMessage(slot, msg, sizeof(msg));

    memset(msg, '\0', sizeof(msg));
    sprintf(msg, "*** User '%s' changed their name to '%s'.\n",
        oldname, clients[slot].strName);
    sendChannel(slot, clients[slot].strChannel, msg, sizeof(msg));
}


void client_execChannel(int slot, char* channel) { 

    char msg[MSG_LENGTH];
    char oldchannel[STR_LENGTH];
    
    if (strcmp(channel, clients[slot].strChannel) == 0) {
        /* The user is already in this channel and nothing needs to be done. */
        sendMessage(slot, MSG_CMD_CHANNEL_SAME, sizeof(MSG_CMD_CHANNEL_SAME));
        return;
    }

    /* Keep a copy of the old channel so we know where to message. */
    memset(oldchannel, '\0', sizeof(oldchannel));
    Strncpy(oldchannel, clients[slot].strChannel, STR_LENGTH);
   
    /* Change to the new channel. */
    Strncpy(clients[slot].strChannel, channel, STR_LENGTH);

    
    /* Now if were not already in this channel first send a message to the old
     * channel that we have switched channels and then one to our new channel
     * once. */
    memset(msg, '\0', sizeof(msg));
    sprintf(msg, "*** User '%s' has left this channel.\n",
        clients[slot].strName);
    sendChannel(slot, oldchannel, msg, sizeof(msg));
    
    memset(msg, '\0', sizeof(msg));
    sprintf(msg, "*** Your channel has been changed to '%s'.\n",
        clients[slot].strChannel);
    sendMessage(slot, msg, sizeof(msg));

    memset(msg, '\0', sizeof(msg));
    sprintf(msg, "*** User '%s' has joined this channel.\n",
        clients[slot].strName);
    sendChannel(slot, clients[slot].strChannel, msg, sizeof(msg));
}


void client_execDetails(int slot) {

    char msg[MSG_LENGTH];
    
    memset(msg, '\0', sizeof(msg));

    /* Now send the client their details. */
    sprintf(msg, \
        "*** Details:\n" \
        "***    Client ID:  %d\n" \
        "***    IP Address: %s\n" \
        "***    Name:       %s\n" \
        "***    Channel:    %s\n",
        slot, clients[slot].strIP,
        clients[slot].strName, clients[slot].strChannel);
    sendMessage(slot, msg, sizeof(msg));
}


void client_execConnect(int slot, char* ip) {

    char name[STR_LENGTH];

    memset(name, '\0', sizeof(name));
    sprintf(name, "Anonymous_Coward_%d", slot);

    /* Set the clients ip address to the given address. */
    Strncpy(clients[slot].strIP, ip, STRIP_LENGTH);

    /* Set our clients name to "Anonymous_Coward_ID" so it encourages them to
     * change their name. */
    client_execName(slot, name);

    /* Set the clients channel to lobby as that is where all users start. */
    client_execChannel(slot, "lobby");

    printf("SERVER Connection accepted:  FD=%d  Slot=%d  IP=%s\n",
	    clients[slot].intFD, slot, clients[slot].strIP);

    sendMessage(slot, MSG_CONNECT, sizeof(MSG_CONNECT));
}


void client_execDisconnect(int slot) {

    char msg[MSG_LENGTH];

    memset(msg, '\0', sizeof(msg));
    
    printf("SERVER Client disconnected:  FD=%d  Slot=%d  IP=%s\n",
        clients[slot].intFD, slot, clients[slot].strIP);
	
    /* Close the clients socket and remove it from the socket set. */
	close(clients[slot].intFD);
	FD_CLR(clients[slot].intFD, &socks);
    
    /* Now send a message to the channel the client was connected to saying that
     * the client has left. */
    sprintf(msg, "*** User '%s' has left this server.\n",
        clients[slot].strName);
    sendChannel(slot, clients[slot].strChannel, msg, sizeof(msg));

    /* Reset the client structure which was associated with this client. This
     * free the slot up for another client. */
    memset(&clients[slot], '\0', sizeof(struct client));
}


void client_execUsers(int slot) {

    int i = 0;
    int c = 0;
    char msg[MSG_LENGTH];

    /* Send header. */
    memset(msg, '\0', sizeof(msg));
    sprintf(msg, "*** Users in channel '%s' are:\n", clients[slot].strChannel);
    sendMessage(slot, msg, sizeof(msg));

   /* Loop through all clients. Printing who is in the current channel. */
    for (i=0; i < MAX_CLIENTS; ++i) {
        /* Check if client is in your channel. */
        if (strcmp(clients[i].strChannel, clients[slot].strChannel) == 0) {
            /* Print out the clients name. */
            memset(msg, '\0', sizeof(msg));
            sprintf(msg, "***    %s\n", clients[i].strName);
            sendMessage(slot, msg, sizeof(msg));
        }

        /* Check if this slot is occupied. */
        if (FD_ISSET(clients[i].intFD, &socks)) {
            /* Increment counter. */
            c++;
        }

    }

    /* Send footer. */
    memset(msg, '\0', sizeof(msg));
    sprintf(msg, "***\n*** Total users on this server is %d.\n",c);
    sendMessage(slot, msg, sizeof(msg));

}

void client_execList(int slot) {
/*added this so that all active clients can be viewed*/
    int i = 0;
    int c = 0;
    char msg[MSG_LENGTH];

    /* Send header. */
    memset(msg, '\0', sizeof(msg));
    sprintf(msg, "*** Users List\n");
    sendMessage(slot, msg, sizeof(msg));

   /* Loop through all clients. Printing who is in the current channel. */
    for (i=0; i < MAX_CLIENTS; ++i) {
	/* Check if this slot is occupied. */
 	if (FD_ISSET(clients[i].intFD, &socks)) {
            /* Print out the clients name. and channel */
            memset(msg, '\0', sizeof(msg));
            sprintf(msg, "*** User: %s ; Channel: %s\n", clients[i].strName, clients[i].strChannel);
            sendMessage(slot, msg, sizeof(msg));
	/* Increment counter. */
            c++;
        }

 	}

    /* Send footer. */
    memset(msg, '\0', sizeof(msg));
    sprintf(msg, "***\n*** Total users on this server is %d.\n",c);
    sendMessage(slot, msg, sizeof(msg));

}
