#ifndef __CLIENT
#define __CLIENT 1


#include "string.h"

#include "configure.h"
#include "messages.h"


struct client {

    /* The associated socket file descriptor. */
    int intFD;

    /* The internet protocol address. xxx.xxx.xxx.xxx\0
     * Thus it needs a length of 16 (ie: the address plus the null terminator
     * at the end). */
    char strIP[STRIP_LENGTH];

    /* The name/nickname/handle that this client wishes to use. */
    char strName[STR_LENGTH];

    /* The channel in which this client is participating in. */
    char strChannel[STR_LENGTH];

};


void client_execConnect(int, char*);
void client_execDisconnect(int);

void client_execDetails(int);
void client_execChannel(int, char*);
void client_execName(int, char*);
void client_execUsers(int);

void client_execList(int);


#endif
