#ifndef __CONFIGURE
#define __CONFIGURE 1

/* Set to 'if (1)' if you want to print out debugging information otherwise set
 * it to 'if (0)' and it won't print out anything. To use it just put DEBUG
 * before the line you wish to executed only for debugging. */
#define DEBUG if (0)

/* The number of connections listen should queue wwhen servicing a connection.*/
#define LISTEN_QUEUE_SIZE 5

/* The maximum number of clients that this server will service.
 * Can be replaced with (FD_SETSIZE-1) for the OS maximum. */
#define MAX_CLIENTS 3

/* The maximum length of the send and receive buffer. */
#define MSG_LENGTH 256

/* The maximum string length (including null terminator) for client name,
 * channel name, etc. */
#define STR_LENGTH 64

/* The length of strings which store an IP address. This should be 16 because
 * the IP address can take a maximum of 15 characters and then 1 more is
 * required for the null terminator. */
#define STRIP_LENGTH 16

/* The IP the server is listening on. Currently not implemented. */
#define SERVER_IP "127.0.0.1"

/* The port the server is listening on for new connections. */
#define SERVER_PORT 7878


#endif
